<?php
use App\Currency;
use App\ReviewRating;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Storage;

if (!function_exists('get_release')) {
    function get_release()
    {
        $version = @file_get_contents(storage_path() . '/app/bugfixer/version.json');
        $version = json_decode($version, true);
        echo $version['subversion'];
    }
}

/**
 * Get decrypted Envato personal token from storage
 */
if (!function_exists('getEnvatoToken')) {
    function getEnvatoToken()
    {
        $filePath = 'token/token.json';
        if (Storage::exists($filePath)) {
            $fileContents = Storage::get($filePath);
            $tokenData = json_decode($fileContents, true);

            if (isset($tokenData['encrypted_token'])) {
                return Crypt::decryptString($tokenData['encrypted_token']);
            }
        }

        return null; // fallback if no token found
    }
}

function purchase_code($code)
{
    $personalToken = getEnvatoToken();
    if (!$personalToken) {
        return __("Token not found");
    }

    if (!preg_match("/^(\w{8})-((\w{4})-){3}(\w{12})$/", $code)) {
        return __("Invalid Purchase Code");
    }

    $ch = curl_init($code);
    curl_setopt_array($ch, [
        CURLOPT_URL => "https://api.envato.com/v3/market/author/sale?code={$code}",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 20,
        CURLOPT_HTTPHEADER => [
            "Authorization: Bearer {$personalToken}",
        ],
    ]);

    $response = curl_exec($ch);

    if (curl_errno($ch) > 0) {
        return __("Error connecting to API !");
    }

    $responseCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    if ($responseCode === 403 || $responseCode === 404) {
        return reverify($code);
    }

    if ($responseCode !== 200) {
        return __("Failed to validate code.");
    }

    $body = json_decode($response);

    if ($body === false && json_last_error() !== JSON_ERROR_NONE) {
        return __("Can't Verify Now.");
    }

    return $responseCode;
}

function reverify($code)
{
    $personalToken = getEnvatoToken();
    if (!$personalToken) {
        return __("Token not found");
    }

    if (!preg_match("/^(\w{8})-((\w{4})-){3}(\w{12})$/", $code)) {
        return __("Invalid Purchase Code");
    }

    $ch = curl_init($code);
    curl_setopt_array($ch, [
        CURLOPT_URL => "https://api.envato.com/v3/market/author/sale?code={$code}",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 20,
        CURLOPT_HTTPHEADER => [
            "Authorization: Bearer {$personalToken}",
        ],
    ]);

    $response = curl_exec($ch);

    if (curl_errno($ch) > 0) {
        return __("Error connecting to API !");
    }

    $responseCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    if ($responseCode === 404) {
        return reverify($code); // recursive retry
    }

    if ($responseCode !== 200) {
        return __("Failed to validate code.");
    }

    $body = json_decode($response);

    if ($body === false && json_last_error() !== JSON_ERROR_NONE) {
        return __("Can't Verify Now.");
    }

    return (isset($body->item->id) && $body->item->id == '34807246') ? 200 : 404;
}

if (!function_exists('course_rating')) {
    function course_rating($id)
    {
        if (isset($id)) {
            $reviews = ReviewRating::where('course_id', $id)->where('status', '1')->get();
            $count = ReviewRating::where('course_id', $id)->count();
            $learn = 0;
            $price = 0;
            $value = 0;
            $sub_total = 0;
            $total_rating_percent = 0;
            $course_total_rating = 0;
            $total_rating = 0;

            if ($count > 0) {
                foreach ($reviews as $review) {
                    $learn = $review->learn * 5;
                    $price = $review->price * 5;
                    $value = $review->value * 5;
                    $sub_total = $sub_total + $learn + $price + $value;
                }
                $count = ($count * 3) * 5;
                $rat = $sub_total / $count;
                $ratings_var0 = ($rat * 100) / 5;
                $course_total_rating = $ratings_var0;
            }

            $count = ($count * 3) * 5;
            if ($count != "" && $count != 0) {
                $rat = $sub_total / $count;
                $ratings_var = ($rat * 100) / 5;
                $overallrating = ($ratings_var0 / 2) / 10;
                $total_rating = round($overallrating, 1);
            }

            $total_rating_percent = round($course_total_rating, 2);

            return response()->json([
                'total_rating' => $total_rating,
                'total_rating_percent' => $total_rating_percent,
            ]);
        }
    }
}

if (!function_exists('price_format')) {
    function price_format($price)
    {
        if (env('PRICE_DISPLAY_FORMAT') == 'comma') {
            return sprintf('%s', number_format($price, 2, ',', ' '));
        } else {
            return number_format($price, 2, '.', '');
        }
    }
}

if (!function_exists('activeCurrency')) {
    function activeCurrency()
    {
        if (session()->has('changed_currency')) {
            $cur = Currency::where('code', '=', session()->get('changed_currency'))->first();
            if (isset($cur)) {
                return response()->json([
                    'symbol' => $cur->symbol,
                    'position' => $cur->position
                ]);
            }
        } else {
            $cur = Currency::where('default', '=', '1')->first();
            if (isset($cur)) {
                return response()->json([
                    'symbol' => $cur->symbol,
                    'position' => $cur->position
                ]);
            }
        }
    }
}
