<?php

namespace App\Http\Controllers;

use App\Advertisement;
use Illuminate\Http\Request;
use File;
use Image;
use Session;
use Spatie\Permission\Models\Role;


class AdvertisementController extends Controller
{
    public function __construct()
    {
    
        $this->middleware('permission:front-settings.advertisement.view', ['only' => ['index','show']]);
        $this->middleware('permission:front-settings.advertisement.create', ['only' => ['create', 'store']]);
        $this->middleware('permission:front-settings.advertisement.edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:front-settings.advertisement.delete', ['only' => ['destroy']]);
    
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $advertisement = Advertisement::get();
        return view('admin.advertisement.index',compact('advertisement'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.advertisement.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // ✅ Validate only image type
        $request->validate([
            'image1' => 'required|mimes:jpeg,jpg,png,webp|max:2048',
        ]);

        $input = $request->all();

        if ($file = $request->file('image1')) {

            $path = 'images/advertisement/';

            // Create folder if not exists
            if (!file_exists(public_path($path))) {
                mkdir(public_path($path), 0777, true);
            }

            // Generate unique file name
            $imageName = time() . '_' . $file->getClientOriginalName();

            // Move file to public/images/advertisement
            $file->move(public_path($path), $imageName);

            // Save file name in DB
            $input['image1'] = $imageName;
        }

        $input['status'] = $request->has('status') ? 1 : 0;

        // Save to DB
        $data = Advertisement::create($input);

        Session::flash('success', trans('flash.AddedSuccessfully'));
        return redirect('advertisement');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Advertisement  $advertisement
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $advs = Advertisement::find($id);
        return view('admin.advertisement.edit',compact('advs'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Advertisement  $advertisement
     * @return \Illuminate\Http\Response
     */
    public function edit(Advertisement $advertisement)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Advertisement  $advertisement
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $ads = Advertisement::findOrFail($id);

        $input = $request->all();

        if ($file = $request->file('image1')) {
            // Define the upload path
            $uploadPath = public_path('images/advertisement/');

            // Check if the old image exists and delete it
            if ($ads->image1 && file_exists($uploadPath . $ads->image1)) {
                unlink($uploadPath . $ads->image1);
            }

            // Generate a unique filename
            $imageName = time() . '_' . $file->getClientOriginalName();

            // Move the uploaded file to the destination
            if ($file->move($uploadPath, $imageName)) {
                $input['image1'] = $imageName;
            } else {
                // Handle error if file move fails (optional logging or flash message)
                Session::flash('error', 'Failed to upload image.');
                return redirect()->back();
            }
        }

        // Update the status field
        $input['status'] = isset($request->status) ? 1 : 0;

        // Update the advertisement record
        $ads->update($input);

        Session::flash('success', trans('flash.UpdatedSuccessfully'));
        return redirect('advertisement');
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Advertisement  $advertisement
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {
        $adv = Advertisement::find($id);

        if ($adv->image1 != null)
        {
                
            $image_file = @file_get_contents(public_path().'/images/advertisement/'.$adv->image1);

            if($image_file)
            {
                unlink(public_path().'/images/advertisement/'.$adv->image1);
            }
        }
        
        $value = $adv->delete();

        if($value)
        {
            session()->flash('delete',trans('flash.DeletedSuccessfully'));
            return redirect('advertisement');
        }
    }
}
