<?php

namespace App\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Crypt;
use Jackiedo\DotenvEditor\Facades\DotenvEditor;
use Illuminate\Support\Str;
use Nwidart\Modules\Facades\Module;

class ConfigurationController extends Controller
{

    private $key;

    public function __construct()
    {
        $this->key = DB::table('api_keys')
                        ->where('id', '2')
                        ->first();
    }

    public function index(Request $request, $theme)
    {
        $module = Module::find($theme);
        
        ini_set("zlib.output_compression", "Off");

        $key = $this->key;
        
        return view('configuration', compact('key','module'));
    }

    public function update(Request $request, $theme)
    {
        if (config('app.demolock') == 1) {
            return back()->with('delete', 'Disabled in demo');
        }
        
        $module = Module::find($theme);
        $d = \Request::getHost();

        $domain = str_replace("www.", "", $d);

        if (strstr($domain, 'localhost') || strstr($domain, '192.168.') || strstr($domain, '.test') || strstr($domain, 'mediacity.co.in') || strstr($domain, 'castleindia.in')) {

            if(!$this->key){
                $secret = Str::uuid();
                DB::table('api_keys')->insert([
                    'secret_key' => filter_var($secret), 
                    'user_id'    => auth()->id(),
                    'created_at' => now(),
                    'updated_at' => now()
                ]);
            }
            
            if ($request->status=='on') {
                $module->enable();
                DotenvEditor::setKeys([
                    'DEFAULT_THEME' => 'blizzard',
                ])->save();
            } else {
                $module->disable();
            }

            DotenvEditor::setKeys([
                'MIX_THEME_FOLDER' => $request->mix_theme,
            ])->save();

            Session::flash('success', 'Updated successfully');
            return back()->withInput();

        } else {
            $request->validate([
                'purchase_code' => 'required',
            ],[
                'purchase_code.required' => 'Please enter your envato purchase code !',
            ]);

            $code = request()->purchase_code;

            if ($request->status=='on') {
                $module->enable();
            } else {
                $module->disable();
            }

            /**
             * ✅ Read encrypted token
             */
            $filePath = 'token/token.json';
            $decryptedToken = null;

            if (Storage::exists($filePath)) {
                $fileContents = Storage::get($filePath);
                $tokenData = json_decode($fileContents, true);

                if (isset($tokenData['encrypted_token'])) {
                    try {
                        $decryptedToken = Crypt::decryptString($tokenData['encrypted_token']);
                        $decryptedToken = trim($decryptedToken, 's:32:"";');
                    } catch (\Exception $e) {
                        return back()->withErrors("Unable to decrypt API token.")->withInput();
                    }
                }
            }

            if (empty($decryptedToken)) {
                return back()->withErrors("API Token not found or invalid.")->withInput();
            }

            // Validate purchase code format
            if (!preg_match("/^(\w{8})-((\w{4})-){3}(\w{12})$/", $code)) {
                $message = __("Invalid Purchase Code");
                return back()->withErrors($message)->withInput();
            }

            // Call Envato API
            $ch = curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => "https://api.envato.com/v3/market/author/sale?code={$code}",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_TIMEOUT => 20,
                CURLOPT_HTTPHEADER => [
                    "Authorization: Bearer {$decryptedToken}",
                ],
            ]);

            $response = curl_exec($ch);

            if (curl_errno($ch) > 0) {
                $message = __("Error connecting to API !");
                return back()->withErrors($message)->withInput();
            }

            $responseCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            if ($responseCode === 404) {
                $message = __("Purchase Code is invalid");
                return back()->withErrors($message)->withInput();
            }
            if ($responseCode !== 200) {
                $message = __("Failed to validate code.");
                return back()->withErrors($message)->withInput();
            }

            $body = json_decode($response);

            if ($body === false && json_last_error() !== JSON_ERROR_NONE) {
                $message = __("Can't Verify Now.");
                return back()->withErrors($message)->withInput();
            }

            if ($body->item->id == '34807246') {
                DotenvEditor::setKeys([
                    'MIX_THEME_FOLDER' => $request->mix_theme,
                ])->save();

                Session::flash('success', 'Updated successfully');
                return back();
            } else {
                $message = __("Please enter Blizzard Theme purchase code.");
                Session::flash('deleted', $message);
                return back()->withInput();
            }
        }
    }

    public function reGenerate()
    {
        if(request()->ajax()){
            if (config('app.demolock') == 1) {
                return response()->json([
                    'status' => 'fail',
                    'msg'    => __('This action is disabled in demo !')
                ]);
            }
    
            if(!$this->key){
                $secret = Str::uuid();
                DB::table('api_keys')->insert([
                    'secret_key' => filter_var($secret), 
                    'user_id'    => auth()->id(),
                    'created_at' => now(),
                    'updated_at' => now()
                ]);
            } else {
                $secret = Str::uuid();
                DB::table('api_keys')
                    ->where('id','=','2')
                    ->update([
                        'secret_key' => filter_var($secret),
                        'updated_at' => now()
                    ]);
            }
    
            return response()->json([
                'status' => 'success',
                'msg'    => __('Keys updated successfully !'),
                'key'    =>  DB::table('api_keys')
                            ->where('id', '2')
                            ->first()
                            ->secret_key
            ]);
        }
    }

    public function getSecret()
    {
        if(request()->ajax()){
            try{
                return response()->json([
                    'status' => 'success',
                    'key'    =>  DB::table('api_keys')
                                ->where('id', '2')
                                ->first()
                                ->secret_key
                ]);
            }catch(\Exception $e){
                return response()->json([
                    'status' => 'fail',
                    'key'    => $e->getMessage()
                ]);
            }
        }
    }
}
