<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Storage;
use Session;

class GenerateApiController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function getkey()
    {
        ini_set("zlib.output_compression", "Off");
        if (Auth::check()) {
            $key = DB::table('api_keys')->first();
            return view('admin.apikeys.getkey', compact('key'));
        } else {
            return redirect()->route('login');
        }
    }

    public function createKey(Request $request)
    {
        if(config('app.demolock') == 1){
            return back()->with('delete','Disabled in demo');
        }

        $d = \Request::getHost();
        $domain = str_replace("www.", "", $d);

        // Localhost / Dev bypass
        if(strstr($domain,'localhost') || strstr($domain, '192.168.') || strstr($domain,'.test') || strstr($domain,'mediacity.co.in') || strstr($domain,'castleindia.in')){
            $put = 1;
            file_put_contents(public_path().'/config.txt', $put);
            return $this->keysupdate($request);
        }
        else {
            $request->validate([
                'purchase_code'=>'required'
            ],[
                'purchase_code.required'=>'Please enter your Envato purchase code!'
            ]);

            $code = $request->purchase_code;

            /**
             * ✅ Read encrypted token
             */
            $filePath = 'token/token.json';
            $decryptedToken = null;

            if (Storage::exists($filePath)) {
                $fileContents = Storage::get($filePath);
                $tokenData = json_decode($fileContents, true);

                if (isset($tokenData['encrypted_token'])) {
                    try {
                        $decryptedToken = Crypt::decryptString($tokenData['encrypted_token']);
                        $decryptedToken = trim($decryptedToken, 's:32:"";');
                    } catch (\Exception $e) {
                        return back()->withErrors("Unable to decrypt API token.")->withInput();
                    }
                }
            }

            if (empty($decryptedToken)) {
                return back()->withErrors("API Token not found or invalid.")->withInput();
            }

            // Validate purchase code format
            if (!preg_match("/^(\w{8})-((\w{4})-){3}(\w{12})$/", $code)) {
                $message = __("Invalid Purchase Code");
                return back()->withErrors($message)->withInput();
            }

            // Call Envato API
            $ch = curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => "https://api.envato.com/v3/market/author/sale?code={$code}",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_TIMEOUT => 20,
                CURLOPT_HTTPHEADER => [
                    "Authorization: Bearer {$decryptedToken}",
                ],
            ]);

            $response = curl_exec($ch);

            if (curl_errno($ch) > 0) {
                $message = __("Error connecting to API!");
                return back()->withErrors($message)->withInput();
            }

            $responseCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            if ($responseCode === 404) {
                $message = __("Purchase Code is invalid");
                return back()->withErrors($message)->withInput();
            }
            if ($responseCode !== 200) {
                $message = __("Failed to validate code.");
                return back()->withErrors($message)->withInput();
            }

            $body = json_decode($response);

            if ($body === false && json_last_error() !== JSON_ERROR_NONE) {
                $message = __("Can't Verify Now.");
                return back()->withErrors($message)->withInput();
            }

            // ✅ Check item id
            if(in_array($body->item->id, ['28944416','34807246','39972555'])){
                return $this->keysupdate($request);
            } else {
                $message = __("Please enter eClass App purchase code.");
                Session::flash('success', $message);
                return back()->withInput();
            }
        }
    }

    public function keysupdate(Request $request)
    {
        if(config('app.demolock') == 0){
            $row = DB::table('api_keys')->where('user_id', '=', Auth::user()->id)->first();
            if ($row) {
                DB::table('api_keys')
                  ->where('id', $row->id)
                  ->update(['secret_key' => (string) Str::uuid()]);
                Session::flash('success', 'Key is re-generated successfully!');
                return back();
            } else {
                $key = DB::table('api_keys')->insert([
                    'secret_key' => (string) Str::uuid(),
                    'user_id' => Auth::user()->id,
                ]);
                if ($key) {
                    Session::flash('success', 'Key is generated successfully!');
                    return back();
                }
            }
        }
        return back()->with('delete','You can\'t update key in Demo');
    }
}
