<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Storage;


class InitializeController extends Controller
{
    public function verify(Request $request)
    {

        $d = \Request::getHost();
        $domain = str_replace("www.", "", $d);   
     
        $alldata = ['app_id' => "25613271", 'ip' => "127.0.0.1", 'domain' => $domain , 'code' => $request->code];
        $data = $this->make_request($alldata);

        if ($data['status'] != 1)
        {   
            $put = 1;
            file_put_contents(public_path().'/config.txt', $put);
            $status = 'complete';
            $status = Crypt::encrypt($status);
            @file_put_contents(public_path().'/step3.txt', $status);
            return redirect()->route('installApp');
        }
        elseif ($data['msg'] == 'Already Register')
        {   
            return back()->withErrors(['User is already registered']);
        }
        else
        {
            return back()->withErrors([$data['msg']]);
        }
    }

    public function make_request($alldata)
    {
        $filePath = 'token/token.json';
        $decryptedToken = null;
        if (Storage::exists($filePath)) {
            $fileContents = Storage::get($filePath);
            $tokenData = json_decode($fileContents, true);
            
            if (isset($tokenData['encrypted_token'])) {
                $decryptedToken = Crypt::decryptString($tokenData['encrypted_token']);
                $decryptedToken = trim($decryptedToken, 's:32:"";');
            }
        }

        $code = $alldata['code'];

       $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => "https://api.envato.com/v3/market/author/sale?code={$code}",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 20,
            CURLOPT_HTTPHEADER => [
                "Authorization: Bearer {$decryptedToken}",
            ],
        ]);

        // Execute request
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        // Parse response
        $result = json_decode($response, true);


        if ($httpCode == 200) 
        {
            $lic_json = array(
                'name'     => request()->user_id,
                'code'     => $alldata['code'],
                'type'     => __('envato'),
                'domain'   => $alldata['domain'],
                'lic_type' => __('regular'),
                'token'    => $decryptedToken
            );

            $file = json_encode($lic_json);
            $filename = 'license.json';

            Storage::disk('local')->put('/keys/'.$filename, $file);

            return [
                'msg' => 'License verification successful',
                'status' => '1'
            ];
        }
        else 
        {
            return [
                'msg' =>'Verification failed',
                'status' => '0'
            ];
        }
    }

}

