<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Setting;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Crypt;
use DotenvEditor;
use Session;
use Spatie\Permission\Models\Role;

class SubscriptionEnableController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:instructor-instructor-plan.manage', ['only' => ['view','settings']]);
    }

    public function view(Request $request)
    {
        return view('admin.instructor.plan.settings');
    }

    public function settings(Request $request)
    {
        if (isset($request->ENABLE_INSTRUCTOR_SUBS_SYSTEM)) {
            
            request()->validate([
                'purchase_code' => 'required'
            ]);

            $code = request()->purchase_code;

            // ✅ Load encrypted token from storage
            $filePath = 'token/token.json';
            $decryptedToken = null;

            if (Storage::exists($filePath)) {
                $fileContents = Storage::get($filePath);
                $tokenData = json_decode($fileContents, true);
                
                if (isset($tokenData['encrypted_token'])) {
                    try {
                        $decryptedToken = Crypt::decryptString($tokenData['encrypted_token']);
                        $decryptedToken = trim($decryptedToken, 's:32:"";'); // in case of serialized wrapping
                    } catch (\Exception $e) {
                        return back()->withErrors("Unable to decrypt API token.")->withInput();
                    }
                }
            }

            if (empty($decryptedToken)) {
                return back()->withErrors("API Token not found or invalid.")->withInput();
            }

            // Validate purchase code format
            if (!preg_match("/^(\w{8})-((\w{4})-){3}(\w{12})$/", $code)) {
                return back()->withErrors("Invalid Purchase Code")->withInput();
            }

            // Call Envato API
            $ch = curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => "https://api.envato.com/v3/market/author/sale?code={$code}",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_TIMEOUT => 20,
                CURLOPT_HTTPHEADER => [
                    "Authorization: Bearer {$decryptedToken}",
                ],
            ]);

            $response = curl_exec($ch);

            if (curl_errno($ch) > 0) {
                return back()->withErrors("Error connecting to API!")->withInput();
            }

            $responseCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            if ($responseCode === 404) {
                return back()->withErrors("Purchase Code is invalid")->withInput();
            }
            if ($responseCode !== 200) {
                return back()->withErrors("Failed to validate code.")->withInput();
            }

            $body = json_decode($response);

            if ($body === false && json_last_error() !== JSON_ERROR_NONE) {
                return back()->withErrors("Can't Verify Now.")->withInput();
            }

            // ✅ Verify Item & License
            if ($body->item->id == '25613271') {
                if ($body->license == 'Extended License') {
                    $env_keys_save = DotenvEditor::setKeys([
                        'ENABLE_INSTRUCTOR_SUBS_SYSTEM' => 1
                    ]);
                    $env_keys_save->save();

                    Storage::disk('local')->put('/extended/extended.json', $code);

                    Session::flash('success', 'Instructor subscription enabled successfully!');
                    return back()->withInput();
                }

                $env_keys_save = DotenvEditor::setKeys([
                    'ENABLE_INSTRUCTOR_SUBS_SYSTEM' => 0
                ]);
                $env_keys_save->save();

                Session::flash('delete', 'Instructor subscription cannot be enabled with a Regular license.');
                return back()->withInput();
            } else {
                $env_keys_save = DotenvEditor::setKeys([
                    'ENABLE_INSTRUCTOR_SUBS_SYSTEM' => 0
                ]);
                $env_keys_save->save();

                Session::flash('delete', 'Instructor subscription cannot be enabled with this purchase code.');
                return back()->withInput();
            }
        } else {
            $env_keys_save = DotenvEditor::setKeys([
                'ENABLE_INSTRUCTOR_SUBS_SYSTEM' => 0
            ]);
            $env_keys_save->save();
        }
    }

    public function verifyPurchase()
    {
        // Optional custom logic
    }
}
