<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\FrontColorSetting;

class FrontColorSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
   public function run(): void
    {
         $defaultData = [
            'white_bg'              => '#ffffff',
            'black_bg'              => '#000',
            'orange_bg'             => '#ff7350',
            'pinkish_orange_bg'     => '#fe7350',
            'vivid_orange_bg'       => '#faa292',
            'nebula_bg'             => '#d7d7d7',
            'blue_bg'               => '#125875',
            'cyan_blue_bg'          => '#EFF7FF',
            'gray_bg'               => '#777777',
            'dark_gray_bg'          => '#333',
            'charcoal_gray_bg'      => '#444',
            'red_bg'                => '#CD201F',
            'green_bg'              => '#8fb569',

            'white_text'            => '#ffffff',
            'black_text'            => '#000',
            'orange_text'           => '#ff7350',
            'blue_text'             => '#125875',
            'cyan_blue_text'        => '#EFF7FF',
            'grey_text'             => '#777777',
            'dark_grey_text'        => '#333',
            'charcoal_grey_text'    => '#444',
            'red_text'              => '#CD201F',
            'white_border'          => '#ffffff',
            'orange_border'         => '#ff7350',
            'pinkish_orange_border' => '#fe7350',
            'blue_border'           => '#125875',
            'light_blue_border'     => '#245b73',
            'gray_border'           => '#777777',
            'dark_gray_border'      => '#333',
            'green_border'          => '#8fb569',
        ];
        FrontColorSetting::updateOrCreate(
            ['id' => 1],   // condition
            $defaultData   // values
        );
    }
}
