@extends('admin.layouts.master')
@section('title', 'Front Theme Color Settings')
@section('maincontent')
    <?php
    $data['heading'] = 'Front Theme Color Settings';
    $data['title'] = 'Front Theme Settings';
    $data['title1'] = 'Front Theme Color Settings';
    ?>
    @include('admin.layouts.topbar', $data)
    <div class="contentbar dashboard-card">
        <div class="row">
            @if ($errors->any())
                <div class="alert alert-danger" role="alert">
                    @foreach ($errors->all() as $error)
                        <p>{{ $error }}<button type="button" class="close" data-dismiss="alert" aria-label="Close"
                                title="{{ __('Close') }}">
                                <span aria-hidden="true" style="color:red;">&times;</span></button></p>
                    @endforeach
                </div>
            @endif
            <!-- row started -->
            <div class="col-lg-12">
                <div class="card dashboard-card m-b-30">
                    <!-- Card header will display you the heading -->
                    <div class="card-header">
                        <h5 class="card-box">{{ __('Front Theme Color Settings') }}</h5>
                        <div>
                            <div class="widgetbar">
                                <a href="{{ route('frontcoloroption.reset') }}" class="btn btn-danger-rgba"
                                    title="{{ __('Reset') }}"><i class="fa fa-ban"></i> {{ __('Reset') }}</a>
                                <a href="{{ url('theme/settings') }}" class="btn btn-primary-rgba"
                                    title="{{ __('Back') }}"><i
                                        class="feather icon-arrow-left mr-2"></i>{{ __('Back') }}</a>
                            </div>
                        </div>
                    </div>
                    <!-- card body started -->
                    <div class="card-body">
                        <!-- form start -->
                        <form action="{{ url('front/coloroption/update') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <!-- row start -->
                            <div class="row">
                                <div class="col-md-12">
                                    <!-- card start -->
                                    <div class="card">
                                        <!-- card body start -->
                                        <div class="card-body">
                                            <!-- row start -->
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <!-- row start -->
                                                    <div class="row">
                                                        <!-- BlueBackground -->
                                                        <div class="col-md-3">
                                                            <div class="form-group">
                                                                <label class="text-dark"
                                                                    for="blue_bg">{{ __('White Background') }}:</label>
                                                                <input name="white_bg" class="form-control" type="color"
                                                                    value="{{ optional($color)['white_bg'] }}" />
                                                            </div>
                                                        </div>
                                                        <!-- RedBackground -->
                                                        <div class="col-md-3">
                                                            <div class="form-group">
                                                                <label class="text-dark"
                                                                    for="red_bg">{{ __('Black Background') }} :</label>
                                                                <input name="black_bg" class="form-control" type="color"
                                                                    value="{{ optional($color)['black_bg'] }}" />
                                                            </div>
                                                        </div>
                                                        <!-- Grey Background -->
                                                        <div class="col-md-3">
                                                            <div class="form-group">
                                                                <label class="text-dark"
                                                                    for="red_bg">{{ __('Orange Background') }} :</label>
                                                                <input name="orange_bg" class="form-control" type="color"
                                                                    value="{{ optional($color)['orange_bg'] }}" />
                                                            </div>
                                                        </div>
                                                        <!-- Light Grey Background -->
                                                        <div class="col-md-3">
                                                            <div class="form-group">
                                                                <label class="text-dark"
                                                                    for="red_bg">{{ __('Pinkish Orange Background') }}
                                                                    :</label>
                                                                <input name="pinkish_orange_bg" class="form-control"
                                                                    type="color"
                                                                    value="{{ optional($color)['pinkish_orange_bg'] }}" />
                                                            </div>
                                                        </div>
                                                        <!-- Black Background -->
                                                        <div class="col-md-3">
                                                            <div class="form-group">
                                                                <label class="text-dark"
                                                                    for="red_bg">{{ __('Vivid Ornage Background') }}
                                                                    :</label>
                                                                <input name="vivid_orange_bg" class="form-control"
                                                                    type="color"
                                                                    value="{{ optional($color)['vivid_orange_bg'] }}" />
                                                            </div>
                                                        </div>
                                                        <!-- White Background -->
                                                        <div class="col-md-3">
                                                            <div class="form-group">
                                                                <label class="text-dark"
                                                                    for="red_bg">{{ __('Nebula Background') }} :</label>
                                                                <input name="nebula_bg" class="form-control" type="color"
                                                                    value="{{ optional($color)['nebula_bg'] }}" />
                                                            </div>
                                                        </div>
                                                        <!-- Deep Red Background -->
                                                        <div class="col-md-3">
                                                            <div class="form-group">
                                                                <label class="text-dark"
                                                                    for="red_bg">{{ __('Blue Background') }} :</label>
                                                                <input name="blue_bg" class="form-control" type="color"
                                                                    value="{{ optional($color)['blue_bg'] }}" />
                                                            </div>
                                                        </div>
                                                        <div class="col-md-3">
                                                            <div class="form-group">
                                                                <label class="text-dark"
                                                                    for="red_bg">{{ __('Cyan Blue Background') }}
                                                                    :</label>
                                                                <input name="cyan_blue_bg" class="form-control"
                                                                    type="color"
                                                                    value="{{ optional($color)['cyan_blue_bg'] }}" />
                                                            </div>
                                                        </div>
                                                        <div class="col-md-3">
                                                            <div class="form-group">
                                                                <label class="text-dark"
                                                                    for="red_bg">{{ __('Gray Background') }} :</label>
                                                                <input name="gray_bg" class="form-control" type="color"
                                                                    value="{{ optional($color)['gray_bg'] }}" />
                                                            </div>
                                                        </div>
                                                        <div class="col-md-3">
                                                            <div class="form-group">
                                                                <label class="text-dark"
                                                                    for="red_bg">{{ __('Dark Gray Background') }}
                                                                    :</label>
                                                                <input name="dark_gray_bg" class="form-control"
                                                                    type="color"
                                                                    value="{{ optional($color)['dark_gray_bg'] }}" />


                                                            </div>
                                                        </div>
                                                        <div class="col-md-3">
                                                            <div class="form-group">
                                                                <label class="text-dark"
                                                                    for="red_bg">{{ __('Charcoal Gray Background') }}
                                                                    :</label>
                                                                <input name="charcoal_gray_bg" class="form-control"
                                                                    type="color"
                                                                    value="{{ optional($color)['charcoal_gray_bg'] }}" />
                                                            </div>
                                                        </div>
                                                        <div class="col-md-3">
                                                            <div class="form-group">
                                                                <label class="text-dark"
                                                                    for="red_bg">{{ __('Red Background') }}
                                                                    :</label>
                                                                <input name="red_bg" class="form-control"
                                                                    type="color"
                                                                    value="{{ optional($color)['red_bg'] }}" />
                                                            </div>
                                                        </div>
                                                        <div class="col-md-3">
                                                            <div class="form-group">
                                                                <label class="text-dark"
                                                                    for="red_bg">{{ __('Green Background') }}
                                                                    :</label>
                                                                <input name="green_bg" class="form-control"
                                                                    type="color"
                                                                    value="{{ optional($color)['green_bg'] }}" />
                                                            </div>
                                                        </div>
                                                    </div><!-- row end -->
                                                </div><!-- col end -->
                                            </div>
                                            <hr>
                                            <!-- row end -->
                                            <!-- row start -->
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <!-- row start -->
                                                        <div>
                                                            <h5 class="card-title">{{ __('Text Colors Settings') }}</h5>
                                                        </div>
                                                        <div class="row">
                                                            <!-- Text Color Background -->
                                                            <div class="col-md-3">
                                                                <div class="form-group">
                                                                    <label class="text-dark"
                                                                        for="red_bg">{{ __('Black Text') }} :</label>
                                                                    <input name="black_text" class="form-control"
                                                                        type="color"
                                                                        value="{{ optional($color)['black_text'] }}" />
                                                                </div>
                                                            </div>
                                                            <!-- Light Grey Text -->
                                                            <div class="col-md-3">
                                                                <div class="form-group">
                                                                    <label class="text-dark"
                                                                        for="red_bg">{{ __(' Grey Text') }} :</label>
                                                                    <input name="grey_text" class="form-control"
                                                                        type="color"
                                                                        value="{{ optional($color)['grey_text'] }}" />
                                                                </div>
                                                            </div>
                                                            <!-- Dark Grey Text -->
                                                            <div class="col-md-3">
                                                                <div class="form-group">
                                                                    <label class="text-dark"
                                                                        for="red_bg">{{ __('Dark Grey Text') }}
                                                                        :</label>
                                                                    <input name="dark_grey_text" class="form-control"
                                                                        type="color"
                                                                        value="{{ optional($color)['dark_grey_text'] }}" />
                                                                </div>
                                                            </div>
                                                            <!-- Red Text -->
                                                            <div class="col-md-3">
                                                                <div class="form-group">
                                                                    <label class="text-dark"
                                                                        for="red_bg">{{ __('Red Text') }} :</label>
                                                                    <input name="red_text" class="form-control"
                                                                        type="color"
                                                                        value="{{ optional($color)['red_text'] }}" />

                                                                </div>
                                                            </div>
                                                            <!-- Blue Text -->
                                                            <div class="col-md-3">
                                                                <div class="form-group">
                                                                    <label class="text-dark"
                                                                        for="red_bg">{{ __('White Text') }} :</label>
                                                                    <input name="white_text" class="form-control"
                                                                        type="color"
                                                                        value="{{ optional($color)['white_text'] }}" />
                                                                </div>
                                                            </div>
                                                            <!-- Dark Blue Text -->
                                                            <div class="col-md-3">
                                                                <div class="form-group">
                                                                    <label class="text-dark"
                                                                        for="red_bg">{{ __('Orange Text') }} :</label>
                                                                    <input name="orange_text" class="form-control"
                                                                        type="color"
                                                                        value="{{ optional($color)['orange_text'] }}" />

                                                                </div>
                                                            </div>
                                                            <!-- White Text -->
                                                            <div class="col-md-3">
                                                                <div class="form-group">
                                                                    <label class="text-dark"
                                                                        for="red_bg">{{ __('Blue Text') }} :</label>
                                                                    <input name="blue_text" class="form-control"
                                                                        type="color"
                                                                        value="{{ optional($color)['blue_text'] }}" />
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="form-group">
                                                                    <label class="text-dark"
                                                                        for="red_bg">{{ __('Cyan Blue Text') }}
                                                                        :</label>
                                                                    <input name="cyan_blue_text" class="form-control"
                                                                        type="color"
                                                                        value="{{ optional($color)['cyan_blue_text'] }}" />
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="form-group">
                                                                    <label class="text-dark"
                                                                        for="red_bg">{{ __('Charcoal Grey Text') }}
                                                                        :</label>
                                                                    <input name="charcoal_grey_text" class="form-control"
                                                                        type="color"
                                                                        value="{{ optional($color)['cyan_blue_text'] }}" />
                                                                </div>
                                                            </div>
                                                        </div><!-- row end -->
                                                    </div><!-- col end -->
                                                </div>
                                                <hr>
                                                <!-- row end -->
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <!-- row start -->
                                                        <div>
                                                            <h5 class="card-title">{{ __('Border Colors Settings') }}</h5>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-md-3">
                                                                <div class="form-group">
                                                                    <label class="text-dark"
                                                                        for="red_bg">{{ __('Border White') }} :</label>
                                                                    <input name="white_border" class="form-control"
                                                                        type="color"
                                                                        value="{{ optional($color)['white_border'] }}" />
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="form-group">
                                                                    <label class="text-dark"
                                                                        for="red_bg">{{ __('Border Orange') }} :</label>
                                                                    <input name="orange_border" class="form-control"
                                                                        type="color"
                                                                        value="{{ optional($color)['orange_border'] }}" />
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="form-group">
                                                                    <label class="text-dark"
                                                                        for="red_bg">{{ __('Border Pinkish Orange') }}
                                                                        :</label>
                                                                    <input name="pinkish_orange_border"
                                                                        class="form-control" type="color"
                                                                        value="{{ optional($color)['pinkish_orange_border'] }}" />

                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="form-group">
                                                                    <label class="text-dark"
                                                                        for="red_bg">{{ __('Border Blue') }} :</label>
                                                                    <input name="blue_border" class="form-control"
                                                                        type="color"
                                                                        value="{{ optional($color)['blue_border'] }}" />

                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="form-group">
                                                                    <label class="text-dark"
                                                                        for="red_bg">{{ __('Border Light Blue') }}
                                                                        :</label>
                                                                    <input name="light_blue_border" class="form-control"
                                                                        type="color"
                                                                        value="{{ optional($color)['light_blue_border'] }}" />

                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="form-group">
                                                                    <label class="text-dark"
                                                                        for="red_bg">{{ __('Border Gray') }} :</label>
                                                                    <input name="gray_border" class="form-control"
                                                                        type="color"
                                                                        value="{{ optional($color)['gray_border'] }}" />

                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="form-group">
                                                                    <label class="text-dark"
                                                                        for="red_bg">{{ __('Border Dark Gray') }}
                                                                        :</label>
                                                                    <input name="dark_gray_border" class="form-control"
                                                                        type="color"
                                                                        value="{{ optional($color)['dark_gray_border'] }}" />

                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="form-group">
                                                                    <label class="text-dark"
                                                                        for="red_bg">{{ __('Border Green') }} :</label>
                                                                    <input name="green_border" class="form-control"
                                                                        type="color"
                                                                        value="{{ optional($color)['green_border'] }}" />

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <button type="submit" class="btn btn-primary-rgba"
                                                            title="{{ __('Update') }}"><i
                                                                class="fa fa-check-circle"></i>
                                                            {{ __('Update') }}</button>
                                                    </div>
                                                </div>
                                            </div><!-- card body end -->
                                        </div><!-- card end -->
                                    </div><!-- col end -->
                                </div><!-- row end -->
                        </form>
                        <!-- form end -->
                    </div><!-- card body end -->

                </div><!-- col end -->
            </div>
        </div>
    </div><!-- row end -->
    <br><br>
@endsection
<!-- main content section ended -->
