@extends('theme2.master')
@section('title', 'My Courses')
@section('content')
@include('admin.message')
<!-- breadcrumb-area -->
@php
$gets = App\Breadcum::first();
@endphp

<section class="breadcrumb-area d-flex p-relative align-items-center" style="background-image: url('{{ optional($gets)->img ? asset('/images/breadcum/' . $gets->img) : Avatar::create(optional($gets)->text ?? 'My Courses')->toBase64() }}')">
    <div class="overlay-bg"></div>
    <div class="container">
        <div class="row align-items-center">
            <div class="col-xl-12 col-lg-12">
                <div class="breadcrumb-wrap text-left">
                    <div class="breadcrumb-title">
                        <h2>{{ __('My Courses') }}</h2>    
                    </div>
                </div>
            </div>
            <div class="breadcrumb-wrap2">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">{{ __('Home') }}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{ __('My Course') }}</li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>
</section>
<!-- breadcrumb-area-end --> 

@php
$hasCourses = false;
$hasBundleCourses = false;
$bundleCourseIds = [];
@endphp

<!-- Collect all courses (individual and bundle) -->
@foreach ($enroll as $enrol)
    @if ($enrol->status == 1 && $enrol->user_id == Auth::user()->id)
        @if (!empty($enrol->course_id))
            @php
            $hasCourses = true;
            @endphp
        @endif
        @if (!empty($enrol->bundle_id) && ($enrol->subscription_status === 'active' || $enrol->status == 1))
            @php
            $bundle_order = App\BundleCourse::where('id', $enrol->bundle_id)->first();
            @endphp
            @if (!empty($bundle_order) && !empty($bundle_order->course_id))
                @php
                $hasBundleCourses = true;
                $bundleCourseIds = array_merge($bundleCourseIds, $bundle_order->course_id);
                @endphp
            @endif
        @endif
    @endif
@endforeach

<!-- Display courses if any exist -->
@if ($hasCourses || $hasBundleCourses)
<section id="learning-courses" class="learning-courses-main-block my-course-section pt-120 pb-120">
    <div class="container-xl">
        <div class="row">
            <!-- Individual Courses -->
            @foreach ($enroll as $enrol)
                @if (!empty($enrol->course_id) && $enrol->status == 1 && $enrol->user_id == Auth::user()->id)
                    <div class="col-lg-4 col-sm-6">
                        <div class="view-block mb-3">
                            <div class="view-img">
                                <a href="{{ route('course.content', ['slug' => optional($enrol->courses)->slug ?? '#']) }}">
                                    <img src="{{ optional($enrol->courses)->preview_image ? asset('images/course/' . $enrol->courses->preview_image) : Avatar::create(optional($enrol->courses)->title ?? 'Course')->toBase64() }}" class="my-courses-img img-fluid" alt="student">
                                </a>
                            </div>
                            <div class="view-user-img">
                                <a href="{{ route('all/profile', optional($enrol->user)->id ?? 0) }}" title="{{ optional($enrol->courses)->title ?? 'Course' }}">
                                    <img src="{{ optional($enrol->user)->user_img ? asset('images/user_img/' . $enrol->user->user_img) : asset('images/default/user.png') }}" class="img-fluid user-img-one user-img-two" alt="{{ optional($enrol->courses)->title ?? 'Course' }}">
                                </a>
                            </div>
                            <div class="view-dtl">
                                <div class="user-name mb-2">
                                    <div class="username"><i class="fal fa-user me-2"></i>{{ __('By') }} <span><a href="{{ route('all/profile', optional($enrol->user)->id ?? 0) }}">{{ optional($enrol->courses->user)->fname ?? 'Unknown' }}</a></span></div>
                                </div>
                                <div class="view-heading">
                                    <a href="{{ route('course.content', ['slug' => optional($enrol->courses)->slug ?? '#']) }}">{{ str_limit(optional($enrol->courses)->title ?? 'Untitled Course', 35, '...') }}</a>
                                </div>
                                
                                <div class="rating">
                                    <ul>
                                        <li class="rating-section">
                                            @php
                                            $learn = $price = $value = $sub_total = 0;
                                            $reviews = App\ReviewRating::where('course_id', optional($enrol->courses)->id ?? 0)->where('status', '1')->get();
                                            @endphp
                                            @if ($reviews->isNotEmpty())
                                                @php
                                                $count = $reviews->count();
                                                foreach ($reviews as $review) {
                                                    $learn += ($review->learn ?? 0) * 5;
                                                    $price += ($review->price ?? 0) * 5;
                                                    $value += ($review->value ?? 0) * 5;
                                                    $sub_total += $learn + $price + $value;
                                                }
                                                $count = $count * 3 * 5;
                                                $rat = $count > 0 ? $sub_total / $count : 0;
                                                $ratings_var = ($rat * 100) / 5;
                                                @endphp
                                                <div class="pull-left">
                                                    <div class="star-ratings-sprite"><span style="width: {{ $ratings_var }}%" class="star-ratings-sprite-rating"></span></div>
                                                </div>
                                            @else
                                                <div class="no-rating-title">{{ __('No Rating') }}</div>
                                            @endif
                                        </li>
                                        <li class="overall-rating-section">
                                            @php
                                            $reviewcount = App\ReviewRating::where('course_id', optional($enrol->courses)->id ?? 0)->where('status', '1')->whereNotNull('review')->get();
                                            $learn = $price = $value = $sub_total = 0;
                                            foreach ($reviewcount as $review) {
                                                $learn += ($review->learn ?? 0) * 5;
                                                $price += ($review->price ?? 0) * 5;
                                                $value += ($review->value ?? 0) * 5;
                                                $sub_total += $learn + $price + $value;
                                            }
                                            $count = $reviewcount->count() * 3 * 5;
                                            $overallrating = $count > 0 ? round(($sub_total / $count) * 100 / 5 / 10, 1) : null;
                                            @endphp
                                            @if ($overallrating)
                                               <i class="active fa fa-star" aria-hidden="true"></i> <b class="overall-rating-section">{{ $overallrating }}</b><span><i class="fa fa-users me-1"></i>{{ App\ReviewRating::where('course_id', optional($enrol->courses)->id ?? 0)->count() ?? 0 }} {{ __('Reviews') }}</span>
                                            @endif
                                        </li>
                                        <li class="reviews"></li>
                                    </ul>
                                </div>
                                <div class="mycourse-progress">
                                    @php
                                    $progress = App\CourseProgress::where('course_id', optional($enrol->courses)->id ?? 0)->where('user_id', Auth::user()->id)->first();
                                    @endphp
                                    @if (!empty($progress) && !empty($progress->all_chapter_id))
                                        @php
                                        $total_count = count($progress->all_chapter_id);
                                        $read_count = count($progress->mark_chapter_id ?? []);
                                        $progres = $total_count > 0 ? ($read_count / $total_count) * 100 : 0;
                                        @endphp
                                        <div class="complete">{{ __('Complete') }} <span>{{ $progres }}%</span></div>
                                        <div class="progress">
                                            <div class="progress-bar progress-bar-striped bg-success" role="progressbar" style="width: {{ $progres }}%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100"></div>
                                        </div>
                                        
                                    @else
                                        <div class="progress">
                                            <div class="progress-bar progress-bar-striped bg-success" role="progressbar" style="width: 0%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100"></div>
                                        </div>
                                        <button class="btn btn-primary p-1"><i class="fa fa-play me-2"></i>{{ __('Start Course') }}</button>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
            @endforeach

            <!-- Bundle Courses -->
            @foreach ($enroll as $enrol)
                @if (!empty($enrol->bundle_id) && ($enrol->subscription_status === 'active' || $enrol->status == 1))
                    @php
                    $bundle_order = App\BundleCourse::where('id', $enrol->bundle_id)->first();
                    @endphp
                    @if (!empty($bundle_order) && !empty($bundle_order->course_id))
                        @foreach ($bundle_order->course_id as $bundle_course)
                            @php
                            $coursess = App\Course::where('id', $bundle_course)->first();
                            @endphp
                            @if (!empty($coursess))
                                <div class="col-lg-3 col-sm-6">
                                    <div class="view-block">
                                        <div class="view-img">
                                            <a href="{{ route('course.content', ['slug' => $coursess->slug]) }}">
                                                <img src="{{ optional($coursess)->preview_image ? asset('images/course/' . $coursess->preview_image) : Avatar::create($coursess->title)->toBase64() }}" class="img-fluid" alt="student">
                                            </a>
                                        </div>
                                        <div class="view-user-img">
                                            <a href="{{ route('all/profile', optional($coursess->user)->id ?? 0) }}" title="{{ $coursess->title }}">
                                                <img src="{{ optional($coursess->user)->user_img ? asset('images/user_img/' . $coursess->user->user_img) : asset('images/default/user.png') }}" class="img-fluid user-img-one user-img-two" alt="{{ $coursess->title }}">
                                            </a>
                                        </div>
                                        <div class="view-dtl">
                                            <div class="view-heading">
                                                <a href="{{ route('course.content', ['slug' => $coursess->slug]) }}">{{ str_limit($coursess->title, 35, '...') }}</a>
                                            </div>
                                            <div class="user-name">
                                                <h6>{{ __('By') }} <span><a href="{{ route('all/profile', optional($coursess->user)->id ?? 0) }}">{{ optional($coursess->user)->fname ?? 'Unknown' }}</a></span></h6>
                                            </div>
                                            <div class="rating">
                                                <ul>
                                                    <li>
                                                        @php
                                                        $learn = $price = $value = $sub_total = 0;
                                                        $reviews = App\ReviewRating::where('course_id', $coursess->id)->where('status', '1')->get();
                                                        @endphp
                                                        @if ($reviews->isNotEmpty())
                                                            @php
                                                            $count = $reviews->count();
                                                            foreach ($reviews as $review) {
                                                                $learn += ($review->learn ?? 0) * 5;
                                                                $price += ($review->price ?? 0) * 5;
                                                                $value += ($review->value ?? 0) * 5;
                                                                $sub_total += $learn + $price + $value;
                                                            }
                                                            $count = $count * 3 * 5;
                                                            $rat = $count > 0 ? $sub_total / $count : 0;
                                                            $ratings_var = ($rat * 100) / 5;
                                                            @endphp
                                                            <div class="pull-left">
                                                                <div class="star-ratings-sprite"><span style="width: {{ $ratings_var }}%" class="star-ratings-sprite-rating"></span></div>
                                                            </div>
                                                        @else
                                                            <div class="pull-left">{{ __('No Rating') }}</div>
                                                        @endif
                                                    </li>
                                                    <li>
                                                        @php
                                                        $reviewcount = App\ReviewRating::where('course_id', $coursess->id)->where('status', '1')->whereNotNull('review')->get();
                                                        $learn = $price = $value = $sub_total = 0;
                                                        foreach ($reviewcount as $review) {
                                                            $learn += ($review->learn ?? 0) * 5;
                                                            $price += ($review->price ?? 0) * 5;
                                                            $value += ($review->value ?? 0) * 5;
                                                            $sub_total += $learn + $price + $value;
                                                        }
                                                        $count = $reviewcount->count() * 3 * 5;
                                                        $overallrating = $count > 0 ? round(($sub_total / $count) * 100 / 5 / 10, 1) : null;
                                                        @endphp
                                                        @if ($overallrating)
                                                            <b>{{ $overallrating }}</b>
                                                        @endif
                                                    </li>
                                                    <li class="reviews">({{ App\ReviewRating::where('course_id', $coursess->id)->count() ?? 0 }} {{ __('Reviews') }})</li>
                                                </ul>
                                            </div>
                                            <div class="mycourse-progress">
                                                @php
                                                $progress = App\CourseProgress::where('course_id', $coursess->id)->where('user_id', Auth::user()->id)->first();
                                                @endphp
                                                @if (!empty($progress) && !empty($progress->all_chapter_id))
                                                    @php
                                                    $total_count = count($progress->all_chapter_id);
                                                    $read_count = count($progress->mark_chapter_id ?? []);
                                                    $progres = $total_count > 0 ? ($read_count / $total_count) * 100 : 0;
                                                    @endphp
                                                    <div class="progress">
                                                        <div class="progress-bar progress-bar-striped bg-success" role="progressbar" style="width: {{ $progres }}%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100"></div>
                                                    </div>
                                                    <div class="complete">{{ $progres }}% {{ __('Complete') }}</div>
                                                @else
                                                    <div class="progress">
                                                        <div class="progress-bar progress-bar-striped bg-success" role="progressbar" style="width: 0%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100"></div>
                                                    </div>
                                                    <div class="complete">{{ __('Start Course') }}</div>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    @endif
                @endif
            @endforeach
        </div>
    </div>
</section>
@else
<section id="no-result-block" class="no-result-block">
    <div class="container-xl">
        <div class="no-result-courses">{{ __('When you enroll') }} <a href="{{ url('/') }}"><b>{{ __('Browse') }}</b></a></div>
    </div>
</section>
@endif

<!-- Display "No courses found in this bundle" only if there are bundles but no courses -->
@if (!$hasBundleCourses && !empty($bundleCourseIds))
<section id="no-result-block" class="no-result-block">
    <div class="container-xl">
        <div class="no-result-courses">{{ __('No courses found in this bundle.') }}</div>
    </div>
</section>
@endif

@if (!empty($bigbluemeeting) && count($bigbluemeeting) > 0)
<section id="learning-courses" class="learning-courses-main-block">
    <div class="container-xl">
        <h4 class="student-heading">{{ __('BigBlue Meetings') }}</h4>
        <div class="row">
            @foreach($bigbluemeeting as $bbl)
            <div class="col-lg-3 col-sm-6">
                <div class="view-block">
                    <div class="view-img">
                        <a href="{{ route('bbl.detail', $bbl->id) }}">
                            <img src="{{ Avatar::create($bbl->meetingname ?? 'Meeting')->toBase64() }}" alt="course" class="img-fluid">
                        </a>
                    </div>
                    <div class="view-dtl">
                        <div class="view-heading btm-10">
                            <a href="{{ route('bbl.detail', $bbl->id) }}">{{ str_limit($bbl->meetingname ?? 'Untitled Meeting', 30, '...') }}</a>
                        </div>
                        <p class="btm-10"><a href="#">{{ __('by') }} {{ optional($bbl->user)->fname ?? 'Unknown' }}</a></p>
                        @if (!empty($bbl->start_time))
                        <p class="btm-10"><a href="#">{{ __('Start At') }}: {{ date('d-m-Y | h:i:s A', strtotime($bbl->start_time)) }}</a></p>
                        @endif
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>
@endif

@if (!empty($zoommeeting) && count($zoommeeting) > 0)
<section id="learning-courses" class="learning-courses-main-block">
    <div class="container-xl">
        <h4 class="student-heading">{{ __('Zoom Meetings') }}</h4>
        <div class="row">
            @foreach($zoommeeting as $meeting)
            <div class="col-lg-3 col-sm-6">
                <div class="view-block">
                    <div class="view-img">
                        <a href="{{ route('zoom.detail', $meeting->id) }}">
                            <img src="{{ Avatar::create($meeting->meeting_title ?? 'Meeting')->toBase64() }}" alt="course" class="img-fluid">
                        </a>
                    </div>
                    <div class="view-user-img">
                        <a href="{{ route('all/profile', optional($meeting->user)->id ?? 0) }}" title="{{ $meeting->meeting_title ?? 'Meeting' }}">
                            <img src="{{ optional($meeting->user)->user_img ? asset('images/user_img/' . $meeting->user->user_img) : asset('images/default/user.png') }}" class="img-fluid user-img-one user-img-two" alt="{{ $meeting->meeting_title ?? 'Meeting' }}">
                        </a>
                    </div>
                    <div class="view-dtl">
                        <div class="view-heading">
                            <a href="{{ route('zoom.detail', $meeting->id) }}">{{ str_limit($meeting->meeting_title ?? 'Untitled Meeting', 30, '...') }}</a>
                        </div>
                        <div class="user-name">
                            <h6>{{ __('By') }} <span><a href="{{ route('all/profile', optional($meeting->user)->id ?? 0) }}">{{ optional($meeting->user)->fname ?? 'Unknown' }}</a></span></h6>
                        </div>
                        <div class="view-footer">
                            <div class="row">
                                <div class="col-lg-6 col-md-6 col-sm-6 col-6">
                                    <div class="view-date">
                                        <a href="#"><i data-feather="calendar"></i> {{ !empty($meeting->start_time) ? date('d-m-Y', strtotime($meeting->start_time)) : 'N/A' }}</a>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-6">
                                    <div class="view-time">
                                        <a href="#"><i data-feather="clock"></i> {{ !empty($meeting->start_time) ? date('h:i:s A', strtotime($meeting->start_time)) : 'N/A' }}</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>
@endif

@endsection